/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cmp2.cacheinvalidation.ejb;

import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.ejb.CreateException;


/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public abstract class CBean
   implements EntityBean
{
   private EntityContext ctx;

   public abstract Long getId();
   public abstract void setId(Long id);

   public abstract String getFirstName();
   public abstract void setFirstName(String firstName);

   public abstract String getLastName();
   public abstract void setLastName(String lastName);

   public abstract ALocal getA();
   public abstract void setA(ALocal a);

   public Long ejbCreate(Long id)
      throws CreateException
   {
      setId(id);
      return null;
   }

   public void ejbPostCreate(Long id)
   {
   }

   /**
    * @param  ctx The new entityContext value
    */
   public void setEntityContext(EntityContext ctx)
   {
      this.ctx = ctx;
   }

   /**
    * Unset the associated entity context.
    */
   public void unsetEntityContext()
   {
      this.ctx = null;
   }

   public void ejbActivate()
   {
   }

   public void ejbLoad()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove() throws RemoveException
   {
   }

   public void ejbStore()
   {
   }
}
