/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.test;

import junit.framework.Test;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Test case for clustered session event.
 *
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class SessionEventTestCase
      extends BaseTest
{

   public SessionEventTestCase(String name)
   {
      super(name);

   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(SessionEventTestCase.class,
            "http-sr.war");
      return t1;
   }

   public void testSessionBindingEvent()
      throws Exception
   {
      String attr = "";
      getLog().debug("Enter testSessionBindingEvent");

      String setURLName = "/http-sr/bindSession.jsp" + "?Binding=true";
      String getURLName = "/http-sr/bindSession.jsp" + "?Binding=false";

      getLog().debug(setURLName + ":::::::" + getURLName);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      attr = makeGet(client, baseURL0_ +setURLName);
System.out.println("*** Response is " +attr);

      assertNotNull("Http session get", attr);
      boolean isOK = false;
      if( attr.indexOf("OK") >= 0 ) isOK = true;
      assertTrue("Response for session bound event should be", isOK);
      attr = makeGetWithState(client, baseURL0_ +getURLName);
      if( attr.indexOf("OK") >= 0 ) isOK = true;
      assertNotNull("Http session get", attr);
      assertTrue("Response for session unbound event should be", isOK);
   }

}
