/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.test;

import junit.framework.Test;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Clustering test case of get/set under scoped class loader.
 * Trigger type is set only, i.e., get is not dirty.
 *
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class ScopedSetTriggerTestCase
      extends ScopedTestCase
{

   public ScopedSetTriggerTestCase(String name)
   {
      super(name);
      setUrl = "/http-scoped-set/setSession.jsp";
      getUrl = "/http-scoped-set/getAttribute.jsp";
      modifyUrl = "/http-scoped-set/modifyAttribute.jsp";
      invalidateUrl = "/http-scoped-set/invalidateSession.jsp";

   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(ScopedSetTriggerTestCase.class,
            "http-scoped-set.war");
      return t1;
   }


   /**
    * Test session modify with non-primitive get/modify.
    *
    * @throws Exception
    */
   public void testNonPrimitiveModify()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testNonPrimitiveModify");

      getLog().debug(setUrl + ":::::::" + getUrl);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      makeGet(client, baseURL0_ +setUrl);

      // Create a method instance.
      HttpMethod method = new GetMethod(getUrl);
      // Get the Attribute set
      String attrOld = makeGet(client, baseURL0_ +getUrl);

      // Get the Attribute set
      makeGet(client, baseURL0_ +modifyUrl);

      // Get the Attribute set
      attr = makeGet(client, baseURL0_ +getUrl);

      sleepThread(200);

      // Make connection to server 1 and get
      setCookieDomainToThisServer(client, servers_[1]);
      String attr2 = makeGet(client, baseURL1_ +getUrl);

      // Check the result
      assertEquals("Attributes should be the same", attrOld, attr2);
      getLog().debug("Exit testNonPrimitiveModify");
   }


}
