/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.test;

import junit.framework.Test;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Clustering test case of get/set under scoped class loader.
 * Replication granularity is attribute-based.
 *
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class ScopedAttrBasedTestCase
      extends ScopedTestCase
{

   public ScopedAttrBasedTestCase(String name)
   {
      super(name);
      setUrl = "/http-scoped-attr/setSession.jsp";
      getUrl = "/http-scoped-attr/getAttribute.jsp";
      modifyUrl = "/http-scoped-attr/modifyAttribute.jsp";
      invalidateUrl = "/http-scoped-attr/invalidateSession.jsp";

   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(ScopedAttrBasedTestCase.class,
            "http-scoped-attr.war");
      return t1;
   }

}
