/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.test;

import junit.framework.Test;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossClusteredTestCase;

import java.util.Random;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;

/**
 * Simple clustering test case of get/set. It is attribute based granularity with concurrent access.
 *
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class AttributeBasedConcurrentTestCase
      extends SessionBasedConcurrentTestCase
{
   public AttributeBasedConcurrentTestCase(String name)
   {
      super(name);
      setURLName_ = "/http-scoped-attr/testsessionreplication.jsp";
      getURLName_ = "/http-scoped-attr/getattribute.jsp";
   }

   // Use different war file
   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(AttributeBasedConcurrentTestCase.class,
            "http-scoped-attr.war");
      return t1;
   }
}
