/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cluster.ejb;

import java.rmi.dgc.VMID;
import javax.ejb.SessionBean;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;

import org.jboss.logging.Logger;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class CalleeBean implements SessionBean
{
   private static Logger log = Logger.getLogger(CalleeBean.class);
   private static VMID vmid = new VMID();

   public void ejbCreate() throws CreateException
   {
      log.debug("ejbCreate() called");
   }

   public void ejbActivate()
   {
      log.debug("ejbActivate() called");
   }

   public void ejbPassivate()
   {
      log.debug("ejbPassivate() called");
   }

   public void ejbRemove()
   {
      log.debug("ejbRemove() called");
   }

   public void setSessionContext(SessionContext context)
   {
   }

   public VMID call(String info)
   {
      log.info("call, info="+info+", vmid="+vmid);
      return vmid;
   }
}
