/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.client.test;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.CallbackHandler;

/** A test CallbackHandler that sets any NameCallback name property to the
 * j_username system property and sets any PasswordCallback password property
 * to the j_password system property.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SystemPropertyCallbackHandler implements CallbackHandler
{
   public SystemPropertyCallbackHandler()
   {
   }

   /** Sets any NameCallback name property to the j_username system property
    sets any PasswordCallback password property to the j_password system property.
    @exception UnsupportedCallbackException thrown if any callback of
    type other than NameCallback or PasswordCallback are seen.
    */
   public void handle(Callback[] callbacks) throws
      UnsupportedCallbackException
   {
      for (int i = 0; i < callbacks.length; i++)
      {
         Callback c = callbacks[i];
         if (c instanceof NameCallback)
         {
            NameCallback nc = (NameCallback) c;
            nc.setName(System.getProperty("j_username"));
         }
         else if (c instanceof PasswordCallback)
         {
            PasswordCallback pc = (PasswordCallback) c;
            String password = System.getProperty("j_password");
            if( password != null )
               pc.setPassword(password.toCharArray());
         }
         else
         {
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
         }
      }
   }
}
