/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;

import java.util.List;

//import org.jboss.test.JBossTestCase;


/**
 * LocalTestCase.java that uses standalone aop package.
 * <p/>
 * <p/>
 * Created: Mon May 05 17:30:11 2003
 */

public class ReplicatedAopTest extends TestCase
{
//   Category log = getLog();
   Logger log = Logger.getLogger(ReplicatedAopTest.class);
   TreeCacheAopTester tester, tester1;


   public ReplicatedAopTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log.info("setUp() ....");
      String configFile = "META-INF/replSync-service.xml";
      tester = new TreeCacheAopTester(configFile);
      tester1 = new TreeCacheAopTester(configFile);
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      tester.stop();
      tester1.stop();
      tester = null;
      tester1 = null;
   }

//   public void testDummy() {}

   public void testSetup()
   {
      log.info("testSetup() ....");
      try {
         tester.testSetup();
         tester1.testSetup();
      } catch (Exception ex) {
         ex.printStackTrace();
         fail("testSetup(): fails. " + ex.toString());
      }
   }

   public void testSimple() throws Exception
   {
      log.info("testSimple() ....");
      tester.createPerson("/person/test1", "Ben Wang", 40);
      assertEquals((Object) "Ben Wang", (Object) tester.getName("/person/test1"));
      assertEquals((Object) "Ben Wang", (Object) tester1.getName("/person/test1"));
   }


   public void testDynamicRefSwapping() throws Exception
   {
      tester.createPerson("/person/test3", "Joe", 32);
      Person person = (Person)tester.getPerson("/person/test3");
      try {
         person.setAge(30);
         List med = person.getMedication();
         assertNull("Medication should be null ", med);
         person.setAge(61);
         med = person.getMedication();
         assertEquals("Medication ", (Object)"Lipitor", (Object)med.get(0));
         assertEquals("Medication on cache1 ", (Object)"Lipitor",
               (Object)((Person)tester1.getPerson("/person/test3")).getMedication().get(0));

         person.setAge(71);
         assertEquals("Medication ", (Object)"Vioxx", (Object)med.get(1));
         assertEquals("Medication on cache1 ", (Object)"Vioxx",
               (Object)((Person)tester1.getPerson("/person/test3")).getMedication().get(1));

      } catch (Exception e) {
         // should be thrown
      }
   }

   public void testTransient() throws Exception
   {
      log.info("testTransient() ....");
      tester.createPerson("/person/test1", "Ben Wang", 40);
      tester.setCurrentStatus("/person/test1", "Idle");
      assertEquals("Cache 1 ", (Object) "Idle", (Object) tester.getCurrentStatus("/person/test1"));
      assertEquals("Cache 2 ", (Object) "Active", (Object) tester1.getCurrentStatus("/person/test1"));
   }

   public void testModification() throws Exception
   {
      tester.createPerson("/person/test2", "Ben Wang", 40);
      tester.setName("/person/test2", "Harald Gliebe");
      assertEquals((Object) tester.getName("/person/test2"), (Object) "Harald Gliebe");
      assertEquals((Object) tester1.getName("/person/test2"), (Object) "Harald Gliebe");
      tester.removePerson("/person/test2");
   }

   public void testInheritance() throws Exception
   {
      tester.createStudent("/person/joe", "Joe", 32, "Senior");
      tester.setName("/person/joe", "Joe Black");
      assertEquals((Object) tester.getName("/person/joe"), (Object) "Joe Black");
      assertEquals((Object) tester1.getName("/person/joe"), (Object) "Joe Black");
      tester1.setYear("/person/joe", "Junior");
      assertEquals((Object) tester.getYear("/person/joe"), (Object) "Junior");
      assertEquals((Object) tester1.getYear("/person/joe"), (Object) "Junior");
      tester.removePerson("/person/joe");
   }


   public static Test suite() throws Exception
   {
      return new TestSuite(ReplicatedAopTest.class);
   }


   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

}

