/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;

//import org.jboss.test.JBossTestCase;


/**
 * LocalTestCase.java that uses standalone aop package.
 * <p/>
 * <p/>
 * Created: Mon May 05 17:30:11 2003
 */

public class LocalAopEvictionTest extends TestCase
{
//   Category log = getLog();
   Logger log = Logger.getLogger(LocalAopEvictionTest.class);
   TreeCacheAopTester tester;
   int wakeupIntervalMillis_ = 0;


   public LocalAopEvictionTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log.info("setUp() ....");
      String configFile = "META-INF/local-aop-eviction-service.xml";
      tester = new TreeCacheAopTester(configFile);
      wakeupIntervalMillis_ = tester.cache.getEvictionThreadWakeupIntervalSeconds() *1000;
      log.info("wakeupInterval is " +wakeupIntervalMillis_);
      if(wakeupIntervalMillis_ <=0)
         fail("testEviction(): eviction thread wake up interval is illegal " +wakeupIntervalMillis_);
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      tester.stop();
      tester = null;
   }

//   public void testDummy() {}

   public void testSetup()
   {
      log.info("testSetup() ....");
      try {
         tester.testSetup();
      } catch (Exception ex) {
         ex.printStackTrace();
         fail("testSetup(): fails. " + ex.toString());
      }
   }

   public void testSimple() throws Exception
   {
      log.info("testSimple() ....");
      tester.createPerson("/aop/joe1", "Joe Gibbs I", 32);
      tester.createPerson("/aop/joe2", "Joe Gibbs II", 42);
      tester.createPerson("/aop/joe3", "Joe Gibbs III", 52);
      tester.createPerson("/aop/joe4", "Joe Gibbs IV", 62);
      int period = (wakeupIntervalMillis_ +1000);
      _sleep(period);  // it really depends on the eviction thread time.

      assertEquals((Object) tester.getName("/aop/joe4"), (Object) "Joe Gibbs IV");
      assertTrue(tester.getAge("/aop/joe4") == 62);
      log.info("testCircularReference3(): cache contents " + tester.printCacheDetails());
   }

   public void testReconstruction() throws Exception
   {
      log.info("testReconstruction() ....");
      tester.createPerson("/aop/joe1", "Joe Gibbs I", 32);
      Person joe1 = (Person)tester.getPerson("/aop/joe1");
      tester.createPerson("/aop/joe2", "Joe Gibbs II", 42);
      tester.createPerson("/aop/joe3", "Joe Gibbs III", 52);
      tester.createPerson("/aop/joe4", "Joe Gibbs IV", 62);
      int period = (wakeupIntervalMillis_ +1000);
      _sleep(period);  // it really depends on the eviction thread time.

      assertEquals((Object) joe1.getName(), (Object) "Joe Gibbs I"); // should reconstruct the cache from im-memory
      log.info("testCircularReference3(): cache contents " + tester.printCacheDetails());
   }

   void _sleep(long msecs) {
      try {
         Thread.sleep(msecs);
      } catch (InterruptedException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
   }

   public static Test suite() throws Exception
   {
      return new TestSuite(LocalAopEvictionTest.class);
   }


   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

}

