/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.generic;

import junit.framework.TestCase;
import org.jboss.cache.lock.LockMap;

/**
 * @author Ben Wang
 */
public class LockMapUnitTestCase extends TestCase
{
   private LockMap map_;

   /**
    * Constructor for LockMapTest.
    *
    * @param arg0
    */
   public LockMapUnitTestCase(String arg0)
   {
      super(arg0);
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(LockMapUnitTestCase.class);
   }

   /*
    * @see TestCase#setUp()
    */
   protected void setUp() throws Exception
   {
      super.setUp();
      map_ = new LockMap();
   }

   /*
    * @see TestCase#tearDown()
    */
   protected void tearDown() throws Exception
   {
      super.tearDown();
      map_.removeAll();
   }

   final public void testIsOwner()
   {
      map_.addReader(this);
      assertTrue(map_.isOwner(this, LockMap.OWNER_READ));
      map_.addWriter(this);
      assertTrue(map_.isOwner(this, LockMap.OWNER_WRITE));
      assertTrue(map_.isOwner(this, LockMap.OWNER_ANY));
      map_.removeAll();
   }

   final public void testAddReader()
   {
      map_.addReader(this);
      assertTrue(map_.readerOwners().contains(this));
      map_.removeReader(this);
   }

   final public void testAddWriter()
   {
      map_.addWriter(this);
      assertTrue(map_.writerOwner().equals(this));
      map_.removeWriter(this);
   }

}
