/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.generic;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.Fqn;

import java.util.HashMap;


/**
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a> May 9, 2003
 * @version $Revision:1$
 */
public class FqnUnitTestCase extends TestCase {

   public FqnUnitTestCase(String s) {
      super(s);
   }

   public void setUp() throws Exception {
      super.setUp();
   }

   public void tearDown() throws Exception {
      super.tearDown();
   }

   public void testNull() {
      Fqn fqn=new Fqn();
      log("null fqn is " + fqn);
      assertEquals(0, fqn.size());
   }

   public void testOne() {
      Fqn fqn=new Fqn(new Integer(22));
      log("one fqn is " + fqn);
      assertEquals(1, fqn.size());
   }

   public void testEmptyFqn() {
      Fqn f1=new Fqn();
      Fqn f2=new Fqn();
      assertEquals(f1, f2);
   }

   public void testFqn() {
      Fqn fqn=new Fqn();
      fqn.addFqn("/a/b/c");
      log("fqn is " + fqn);
      assertEquals(3, fqn.size());

      Fqn fqn2=new Fqn(new Object[]{"a", "b", "c"});
      log("fqn2 is " + fqn2);
      assertEquals(3, fqn2.size());
      assertEquals("fqn should equal fqn2", fqn, fqn2);
      assertEquals(fqn.hashCode(), fqn2.hashCode());
   }

   public void testHereogeneousNames() {
      Fqn fqn=new Fqn(new Object[]{"string", new Integer(38), new Boolean(true)});
      log("fqn is " + fqn);
      assertEquals(3, fqn.size());

      Fqn fqn2=new Fqn(new Object[]{"string", new Integer(38), new Boolean(true)});
      assertEquals(fqn, fqn2);
      assertEquals(fqn.hashCode(), fqn2.hashCode());
   }

   public void testHashcode() {
      Fqn fqn1, fqn2;
      fqn1=new Fqn(new Object[]{"a", "b", "c"});
      fqn2=new Fqn();
      fqn2.addFqn("/a/b/c");
      log("fqn is " + fqn1);
      assertEquals(fqn1, fqn2);

      HashMap map=new HashMap();
      map.put(fqn1, new Integer(33));
      map.put(fqn2, new Integer(34));
      assertEquals(1, map.size());
      assertEquals(new Integer(34), map.get(fqn1));
   }

   public void testClone() throws CloneNotSupportedException {
      Fqn fqn1=new Fqn();
      fqn1.addFqn("/a/b/c");
      Fqn fqn2=(Fqn)fqn1.clone();
      assertEquals(fqn1, fqn2);
      assertEquals(fqn1.hashCode(), fqn2.hashCode());
   }

   public void testNullElements() throws CloneNotSupportedException {
      Fqn fqn0=new Fqn((Object)null);
      assertEquals(1, fqn0.size());

      Fqn fqn1=new Fqn(new Object[]{"NULL", null, new Integer(0)});
      assertEquals(3, fqn1.size());

      Fqn fqn2=new Fqn(new Object[]{"NULL", null, new Integer(0), });
      assertEquals(fqn1.hashCode(), fqn2.hashCode());
      assertEquals(fqn1, fqn2);
      assertEquals(fqn1, fqn1.clone());
   }

   public void testIteration() {
      Fqn fqn=Fqn.fromString("/a/b/c");
      assertEquals(3, fqn.size());
      Fqn tmp_fqn=new Fqn();
      assertEquals(0, tmp_fqn.size());
      for(int i=0; i < fqn.size(); i++) {
         Object obj=fqn.get(i);
         tmp_fqn=new Fqn(tmp_fqn, obj);
         assertEquals(tmp_fqn.size(), i+1);
      }
      assertEquals(3, tmp_fqn.size());
      assertEquals(fqn, tmp_fqn);
   }

   public void testIsChildOf() {
      Fqn child=Fqn.fromString("/a/b");
      Fqn parent=Fqn.fromString("/a");
      assertTrue("Is child of ", child.isChildOf(parent));
      assertFalse("Is child of ", parent.isChildOf(child));
   }

   void log(String msg) {
      System.out.println("-- " + msg);
   }

   public static Test suite() {
      return new TestSuite(FqnUnitTestCase.class);
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
