/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.eviction;

import junit.framework.TestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.eviction.RegionNameConflictException;
import org.jboss.cache.eviction.Region;

import java.util.HashMap;

/**
 * @author Ben Wang, Feb 11, 2004
 */
public class RegionManagerUnitTestCase extends TestCase
{
   private final String DEFAULT_REGION = "/_default_/";

   public RegionManagerUnitTestCase(String s)
   {
      super(s);
   }

   public void setUp() throws Exception
   {
      super.setUp();
   }

   public void tearDown() throws Exception
   {
      super.tearDown();
   }

   public void testCreateRegion() {
      String fqn1 = "/a/b/c";
      String fqn2 = "/a/b";
      String fqn3 = "/aop";

      RegionManager regionManager = new RegionManager(null);
      try {
         regionManager.createRegion(DEFAULT_REGION, null);
         regionManager.createRegion(fqn1, null);
         regionManager.createRegion(fqn2, null);
         regionManager.createRegion(fqn3, null);
      } catch (RegionNameConflictException e) {
         fail("Failed to create region");
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }

      Region[] regions = regionManager.getRegions();
      assertEquals("Region size ", 4, regions.length);
   }

   public void testCreateRegion2() {
      String fqn1 = "/a/b/c";
      String fqn2 = "/a/b/";

      RegionManager regionManager = new RegionManager(null);
      try {
         regionManager.createRegion(fqn1, null);
         regionManager.createRegion(fqn2, null);
      } catch (RegionNameConflictException e) {
         fail("Failed to create region");
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }

      Region[] regions = regionManager.getRegions();
      assertEquals("Region size ", 2, regions.length);
      assertEquals("Region 0 ", "/a/b/", regions[0].getFqn());
      assertEquals("Region 1 ", "/a/b/c/", regions[1].getFqn());
      Region region = regionManager.getRegion("/a/b/c/d");
      assertNotNull("Region ", region);
      assertEquals("Region ", "/a/b/c/", region.getFqn());
      region = regionManager.getRegion("/a/b");
      assertNotNull("Region ", region);
      assertEquals("Region ", "/a/b/", region.getFqn());
      region = regionManager.getRegion("/a");
      assertNull("Region ", region);
   }

   public void testRegionConflict() {
      String fqn1 = "/a/b";
      String fqn2 = "/a/b/c";
      String fqn3 = "/aop";

      RegionManager regionManager = new RegionManager(null);
      try {
         regionManager.createRegion(DEFAULT_REGION, null);
         regionManager.createRegion(fqn1, null);
         regionManager.createRegion(fqn2, null);
         regionManager.createRegion(fqn3, null);
      } catch (RegionNameConflictException e) {
         Region[] regions = regionManager.getRegions();
         assertEquals("Region size ", 2, regions.length);
         return;
      }
      fail("testRegionConflict failed");
   }

   public void testRegionConflict2() {
      String fqn1 = "/a/b/";
      String fqn2 = "/a/b/c/";
      String fqn3 = "/a/bc";

      RegionManager regionManager = new RegionManager(null);
      try {
         regionManager.createRegion(fqn1, null);
         regionManager.createRegion(fqn2, null);
         regionManager.createRegion(fqn3, null);
      } catch (RegionNameConflictException e) {
         Region[] regions = regionManager.getRegions();
         assertEquals("Region size ", 1, regions.length);
         return;
      }
      fail("testRegionConflict failed");
   }

   public void testGetRegion() {
      String fqn1 = "/a/bc";
      String fqn2 = "/a/b";

      RegionManager regionManager = new RegionManager(null);
      try {
         regionManager.createRegion(fqn1, null);
      } catch (RegionNameConflictException e) {
         fail("testRegionConflict3 failed " +e);
      }

      Region region = regionManager.getRegion(fqn2);
      assertNull("Region " , region);
   }

   void log(String msg)
   {
      System.out.println("-- " + msg);
   }

   public static Test suite()
   {
      return new TestSuite(RegionManagerUnitTestCase.class);
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(suite());
   }

}
