/*
* JBoss, Home of Professional Open Source
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.aop;

import junit.framework.TestCase;
import junit.framework.Test;

import javax.naming.Context;
import javax.naming.InitialContext;
import java.util.Hashtable;
import org.jboss.test.cache.bean.*;
import org.jboss.test.JBossTestCase;

/**
 * 
 * 
 * @author Andrew D. May
 */
public class CacheObjectMBeanUnitTestCase extends JBossTestCase
{

   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

   /**
    * Constructor for CacheObjectMBeanUnitTestCase.
    * @param arg0
    */
   public CacheObjectMBeanUnitTestCase(String arg0)
   {
      super(arg0);
   }

   public void testBinding() throws Exception
   {
      Hashtable props = new Hashtable();
      props.put(Context.INITIAL_CONTEXT_FACTORY, "org.jnp.interfaces.NamingContextFactory");
      props.put(Context.PROVIDER_URL, "localhost:1099");
      Context ctx = new InitialContext(props);
      CacheObjectMeanTesterHome home = (CacheObjectMeanTesterHome)ctx.lookup(
              CacheObjectMeanTesterHome.JNDI_NAME);
      CacheObjectMeanTester cacheTest = home.create();
      cacheTest.bind("id12345");
   }


   public static Test suite() throws Exception
   {
        return getDeploySetup(getDeploySetup(CacheObjectMBeanUnitTestCase.class, "cachetest.jar"),
            "cacheAoptest.sar");
   }

}
