/*
* JBoss, Home of Professional Open Source
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.bean;

import javax.ejb.*;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

import org.jboss.cache.*;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.test.cache.test.standAloneAop.CacheObject;

/**
 * @ejb.bean name="CacheObjectMeanTester"
 *           type="Stateless" 
 *           view-type="remote"
 *           jndi-name="test/CacheObjectMeanTester"
 *           
 * @ejb.home pattern="{0}Home"
 * 
 * @ejb.interface pattern="{0}"
 */
public class CacheObjectMeanTesterBean implements SessionBean
{
   /** @ejb.interface-method */
   public void bind(String id) throws Exception
   {
      MBeanServer server = (MBeanServer)MBeanServerFactory.findMBeanServer(null).get(0);
      TreeCacheAop cache = (TreeCacheAop)server.getAttribute(new ObjectName("jboss.cache:service=testTreeCacheAop"),
              "Instance");
      cache.putObject(new Fqn(new Object[] {"sessions", id}), new CacheObject(id));
   }

   public void ejbCreate() throws CreateException
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove()
   {
   }

   public void setSessionContext(SessionContext arg0)
   {
   }

}
