/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.bankiiop.interfaces;

import java.rmi.*;
import javax.ejb.*;
import javax.naming.*;

/**
 *      
 *   @author Rickard Oberg
 *   @author $Author:Robert Worsnop$
 *   @version $Revision:1$
 */
public interface Teller
   extends EJBObject
{
   // Constants -----------------------------------------------------
    
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   public void transfer(Account from, Account to, float amount)
      throws RemoteException, BankException;
   
   public Account createAccount(Customer customer, float balance)
      throws RemoteException, BankException;
      
   public Account getAccount(Customer customer, float balance)
      throws RemoteException, BankException;
      
   public Customer getCustomer(String name)
      throws RemoteException, BankException;
      
   public void transferTest(Account from, Account to, float amount, int iter)
      throws java.rmi.RemoteException, BankException;
}

/*
 *   $Id:Teller.java,v 1.0, 2005-06-24 19:17:28Z, Robert Worsnop$
 *   Currently locked by:$Locker:$
 *   Revision:
 *   $Log:
 *    1    Main      1.0         6/24/2005 3:17:28 PM   Robert Worsnop  
 *   $
 *   Revision 1.1.26.1  2005/04/06 16:28:06  starksm
 *   Fix the license header
 *
 *   Revision 1.1  2002/03/15 22:36:29  reverbel
 *   Initial version of the bank test for JBoss/IIOP.
 *
 *   Revision 1.2  2001/01/07 23:14:36  peter
 *   Trying to get JAAS to work within test suite.
 *
 *   Revision 1.1.1.1  2000/06/21 15:52:38  oberg
 *   Initial import of jBoss test. This module contains CTS tests, some simple examples, and small bean suites.
 *
 *
 *  
 */
