/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.bank.interfaces;

import java.util.*;
import java.rmi.*;
import javax.ejb.*;

/**
 *      
 *   @author Rickard Oberg
 *   @author $Author:Robert Worsnop$
 *   @version $Revision:1$
 */
public interface AccountHome
   extends EJBHome
{
   // Constants -----------------------------------------------------
   public static final String COMP_NAME = "java:comp/env/ejb/Account";
   public static final String JNDI_NAME = "bank/Account";
    
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   public Account create(AccountData data)
      throws RemoteException, CreateException;
   
   public Account findByPrimaryKey(String id)
      throws RemoteException, FinderException;
      
   public Collection findAll()
      throws RemoteException, FinderException;
      
   public Collection findByOwner(Customer owner)
      throws RemoteException, FinderException;
      
   public Collection findLargeAccounts(int balance)
      throws RemoteException, FinderException;
}

/*
 *   $Id:AccountHome.java,v 1.0, 2005-06-24 18:43:40Z, Robert Worsnop$
 *   Currently locked by:$Locker:$
 *   Revision:
 *   $Log:
 *    1    Main      1.0         6/24/2005 2:43:40 PM   Robert Worsnop  
 *   $
 *   Revision 1.3.32.1  2005/04/06 16:25:04  starksm
 *   Fix the license header
 *
 *   Revision 1.3  2001/01/20 16:32:52  osh
 *   More cleanup to avoid verifier warnings.
 *
 *   Revision 1.2  2001/01/07 23:14:35  peter
 *   Trying to get JAAS to work within test suite.
 *
 *   Revision 1.1.1.1  2000/06/21 15:52:38  oberg
 *   Initial import of jBoss test. This module contains CTS tests, some simple examples, and small bean suites.
 *
 *
 *  
 */
