/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.test;

import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.test.JBossTestCase;
import org.jboss.test.aop.bean.SimpleBeanInterceptor;
import org.jboss.test.aop.simpleejb.Simple;
import org.jboss.test.aop.simpleejb.SimpleHome;

/**
 * @author ifedorenko
 */
public class SimpleBeanUnitTestCase
   extends JBossTestCase 
{

   public SimpleBeanUnitTestCase(String name)
   {
      super(name);
   }

   public void testEjb() throws Exception
   {
      Context ctx = new InitialContext();
      try 
      {
         Object obj = ctx.lookup("ejb/test/Simple");
         SimpleHome home = (SimpleHome)
                 PortableRemoteObject.narrow(obj, SimpleHome.class);
         Simple test = home.create();
         assertEquals(SimpleBeanInterceptor.RETURN_VALUE, test.getTest());
      } 
      finally
      {
         ctx.close();
      }
   }

   public void testEjbCallerSide() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=SimpleBeanTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testEJBCallside", params, sig);
   }

   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(SimpleBeanUnitTestCase.class));

      AOPTestSetup setup = new AOPTestSetup(suite, "simpleejb.sar");
      return setup; 
   }
}
