/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.aop.test;

import javax.management.ObjectName;
import javax.management.Attribute;

import junit.framework.TestSuite;
import org.jboss.test.JBossTestSetup;

/** A test setup wrapper that enables the AspectManager transformation mode
 * on setUp and disables it on tearDown.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class AOPTestSetup extends JBossTestSetup
{
   public static String ASPECT_MANAGER_NAME = "jboss.aop:service=AspectManager";

   private String jar;

   // Create an initializer for the test suite
   AOPTestSetup(TestSuite suite, String jar) throws Exception
   {
      super(suite);
      this.jar = jar;
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      ObjectName aspectManager = new ObjectName(ASPECT_MANAGER_NAME);
      Attribute enableTransformer = new Attribute("EnableTransformer", Boolean.TRUE);
      getServer().setAttribute(aspectManager, enableTransformer);
      try
      {
         redeploy(jar);
      }
      catch(Exception e)
      {
         // Reset the EnableTransformer to false
         try
         {
            enableTransformer = new Attribute("EnableTransformer", Boolean.FALSE);
            getServer().setAttribute(aspectManager, enableTransformer);
         }
         catch(Exception ex)
         {
            getLog().error("Failed to set EnableTransformer to false", ex);
         }
         throw e;
      }
   }
   protected void tearDown() throws Exception
   {
      Exception undeployException = null;
      try
      {
         undeploy(jar);
      }
      catch(Exception e)
      {
         undeployException = e;
      }
      ObjectName aspectManager = new ObjectName(ASPECT_MANAGER_NAME);
      Attribute enableTransformer = new Attribute("EnableTransformer", Boolean.FALSE);
      getServer().setAttribute(aspectManager, enableTransformer);
      if( undeployException != null )
         throw undeployException;
      super.tearDown();
   }
}
