/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.simpleejb;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 * @author ifedorenko
 * 
 * @ejb:bean type="Stateless" name="test/Simple"
 *      view-type="remote"
 *      jndi-name="ejb/test/Simple"
 * @ejb:transaction type="Required"
 */
public class SimpleBean implements SessionBean
{
   /**
    * @ejb:interface-method
    */
   public String getTest()
   {
      System.out.println("**** in SimpleBean.getTest()");
      return "Test";
   }

   public void ejbActivate() throws EJBException, RemoteException
   {
   }

   public void ejbPassivate() throws EJBException, RemoteException
   {
   }

   public void ejbRemove() throws EJBException, RemoteException
   {
   }

   public void setSessionContext(SessionContext arg0)
      throws EJBException, RemoteException
   {
   }

   public void ejbCreate()
   {
   }

}
