/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.test.aop.simpleejb.SimpleHome;
import org.jboss.test.aop.simpleejb.Simple;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
/**
 *
 * @see Monitorable
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class SimpleBeanTester
   extends ServiceMBeanSupport
   implements MBeanRegistration, SimpleBeanTesterMBean
{
   // Constants ----------------------------------------------------
   // Attributes ---------------------------------------------------
   static Logger log = Logger.getLogger(SimpleBeanTester.class);
   MBeanServer m_mbeanServer;

   // Static -------------------------------------------------------
   
   // Constructors -------------------------------------------------
   public SimpleBeanTester()
   {}
   
   // Public -------------------------------------------------------
   
   // MBeanRegistration implementation -----------------------------------
   public ObjectName preRegister(MBeanServer server, ObjectName name)
   throws Exception
   {
      m_mbeanServer = server;
      return name;
   }
   
   public void postRegister(Boolean registrationDone)
   {}
   public void preDeregister() throws Exception
   {}
   public void postDeregister()
   {}

   protected void startService()
      throws Exception
   {
   }

   protected void stopService() {
   }

   public void testEJBCallside() throws Exception
   {
      SimpleHome home = (SimpleHome)new InitialContext().lookup("ejb/test/Simple");
      Simple bean = home.create();
      SimpleBeanCallerInterceptor.wasCalled = false;
      String value = bean.getTest();
      if (!SimpleBeanCallerInterceptor.wasCalled) throw new Exception("Caller interceptor wasn't called");
      if (!value.equals(SimpleBeanInterceptor.RETURN_VALUE)) throw new Exception("bean interceptor failed");


   }


}

