/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.logging.Logger;

import java.lang.reflect.Method;

/**
 * @author ifedorenko
 */
public class SimpleBeanInterceptor implements org.jboss.aop.advice.Interceptor
{

   static Logger log = Logger.getLogger(SimpleBeanInterceptor.class);
   public static final String RETURN_VALUE = "aspect";
   public String getName()
   {
      return "SimpleInterceptor";
   }

   public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws Throwable
   {
      log.info("in SimpleBeanInterceptor");
      org.jboss.aop.joinpoint.MethodInvocation methodInvocation = (org.jboss.aop.joinpoint.MethodInvocation)invocation;
      final Method m = methodInvocation.getMethod();
      if ("getTest".equals(m.getName()) 
            && "org.jboss.test.aop.simpleejb.SimpleBean".equals(m.getDeclaringClass().getName()) )
      {
         return RETURN_VALUE;
      } 
      else 
      {
         return invocation.invokeNext();
      }
   }
}
