/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.system.ServiceMBeanSupport;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
/**
 *
 * @see Monitorable
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class SecurityTester
   extends ServiceMBeanSupport
   implements SecurityTesterMBean, MBeanRegistration
{
   // Constants ----------------------------------------------------
   // Attributes ---------------------------------------------------
   static Logger log = Logger.getLogger(SecurityTester.class);
   MBeanServer m_mbeanServer;

   // Static -------------------------------------------------------
   
   // Constructors -------------------------------------------------
   public SecurityTester()
   {}
   
   // Public -------------------------------------------------------
   
   // MBeanRegistration implementation -----------------------------------
   public ObjectName preRegister(MBeanServer server, ObjectName name)
   throws Exception
   {
      m_mbeanServer = server;
      return name;
   }
   
   public void postRegister(Boolean registrationDone)
   {}
   public void preDeregister() throws Exception
   {}
   public void postDeregister()
   {}

   protected void startService()
      throws Exception
   {
   }

   protected void stopService() {
   }


   public void testXml()
   {
      try{
         log.info("TESTING XML Security");

         SecurityAssociation.setPrincipal(new SimplePrincipal("somebody"));
         SecurityAssociation.setCredential("password".toCharArray() );            

         log.info("testing unchecked constructor");
         SecuredPOJO pojo = new SecuredPOJO(); // unchecked construction
         log.info("testing unchecked method");
         pojo.unchecked();
         log.info("testing unchecked field");
         pojo.uncheckedField = 5;

         SecurityAssociation.setPrincipal(new SimplePrincipal("authfail"));
         SecurityAssociation.setCredential("password".toCharArray() );            
         
         boolean securityFailure = true;
         try
         {
            log.info("testing auth failure method");
            pojo.someMethod();
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("auth failure was not caught for method");

         securityFailure = true;
         try
         {
            log.info("testing auth failure field");
            pojo.someField = 5;
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("auth failure was not caught for field");
         securityFailure = true;
         try
         {
            log.info("testing auth failure constructor");
            pojo = new SecuredPOJO(4);
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("auth failure was not caught for constructor");

         securityFailure = true;
         SecurityAssociation.setPrincipal(new SimplePrincipal("rolefail"));
         try
         {
            log.info("testing role failure method");
            pojo.someMethod();
         }
         catch (SecurityException ignored) 
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("role failure was not caught for method");

         securityFailure = true;
         try
         {
            log.info("testing role failure field");
            pojo.someField = 5;
         }
         catch (SecurityException ignored) 
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("role failure was not caught field");

         securityFailure = true;
         try
         {
            log.info("testing role failure constructor");
            pojo = new SecuredPOJO(4);
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("role failure was not caught for constructor");

         SecurityAssociation.setPrincipal(new SimplePrincipal("pass"));
         log.info("test pass");
         pojo.someMethod();
         pojo.someField = 5;
         pojo = new SecuredPOJO(5);
         
         log.info("test exclusion");
         securityFailure = true;
         try
         {
            pojo.excluded();
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("excluded failure was not caught for method");

         securityFailure = true;
         try
         {
            pojo.excludedField = "hello";
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("excluded failure was not caught for field");

         securityFailure = true;
         try
         {
            pojo = new SecuredPOJO("hello");
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("excluded failure was not caught for constructor");
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }

   public void testAnnotated()
   {
      try{
         log.info("TESTING Annotated Security");

         SecurityAssociation.setPrincipal(new SimplePrincipal("somebody"));
         SecurityAssociation.setCredential("password".toCharArray() );

         log.info("testing unchecked constructor");
         AnnotatedSecuredPOJO pojo = new AnnotatedSecuredPOJO(); // unchecked construction
         log.info("testing unchecked method");
         pojo.unchecked();
         log.info("testing unchecked field");
         pojo.uncheckedField = 5;

         SecurityAssociation.setPrincipal(new SimplePrincipal("authfail"));
         SecurityAssociation.setCredential("password".toCharArray() );

         boolean securityFailure = true;
         try
         {
            log.info("testing auth failure method");
            pojo.someMethod();
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("auth failure was not caught for method");

         securityFailure = true;
         try
         {
            log.info("testing auth failure field");
            pojo.someField = 5;
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("auth failure was not caught for field");
         securityFailure = true;
         try
         {
            log.info("testing auth failure constructor");
            pojo = new AnnotatedSecuredPOJO(4);
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("auth failure was not caught for constructor");

         securityFailure = true;
         SecurityAssociation.setPrincipal(new SimplePrincipal("rolefail"));
         try
         {
            log.info("testing role failure method");
            pojo.someMethod();
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("role failure was not caught for method");

         securityFailure = true;
         try
         {
            log.info("testing role failure field");
            pojo.someField = 5;
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("role failure was not caught field");

         securityFailure = true;
         try
         {
            log.info("testing role failure constructor");
            pojo = new AnnotatedSecuredPOJO(4);
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }

         if (securityFailure) throw new RuntimeException("role failure was not caught for constructor");

         SecurityAssociation.setPrincipal(new SimplePrincipal("pass"));
         log.info("test pass");
         pojo.someMethod();
         pojo.someField = 5;
         pojo = new AnnotatedSecuredPOJO(5);

         log.info("test exclusion");
         securityFailure = true;
         try
         {
            pojo.excluded();
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("excluded failure was not caught for method");

         securityFailure = true;
         try
         {
            pojo.excludedField = "hello";
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("excluded failure was not caught for field");

         securityFailure = true;
         try
         {
            pojo = new AnnotatedSecuredPOJO("hello");
         }
         catch (SecurityException ignored)
         {
            log.info(ignored.getMessage());
            securityFailure = false;
         }
         if (securityFailure) throw new RuntimeException("excluded failure was not caught for constructor");
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }
}

