/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.ConstructorInvocation;

import java.lang.reflect.Method;
/**
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class POJOWildCardConstructorInterceptor implements Interceptor
{

   public String getName()
   {
      return "POJOWildCardConstructorInterceptor";
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      Object rtn = invocation.invokeNext();
      POJOWildCardConstructorTest pojo = (POJOWildCardConstructorTest)rtn;
      pojo.data = "worked";
      return pojo;
   }

}

