/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aspects.patterns.observable.Observer;
import org.jboss.aspects.patterns.observable.Subject;
import org.jboss.system.ServiceMBeanSupport;
/**
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision:1$
 */
public class ObservableTester
   extends ServiceMBeanSupport
   implements ObservableTesterMBean
{
   // Constants ----------------------------------------------------
   
   // Attributes ---------------------------------------------------

   // Static -------------------------------------------------------
   
   // Constructors -------------------------------------------------

   public ObservableTester()
   {
   }
   
   // Public -------------------------------------------------------

   public void testAll() throws Exception 
   {
      Temperature temperature = new Temperature();
      LogUtil logUtil = new LogUtil();
      
      Subject subject = (Subject) temperature;
      Observer observer = (Observer) logUtil;
      
      subject.addObserver(observer);
      
      temperature.setTemperature(10);
      assertEquals("Temperature=10", logUtil.lastLog);
   }

   public void assertEquals(Object object1, Object object2) throws Exception
   {
      if (object1.equals(object2) == false)
         throw new Exception("Expected " + object1 + " got " + object2);
   }
   
   // Inner classes -------------------------------------------------
}

