/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.Advised;

/**
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class CallingPOJO
{
   POJO pojo;
   NonadvisedPOJO nonpojo;

   public CallingPOJO()
   {
      CallerInterceptor.called = false;
      pojo = new POJO();
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("constructor caller interceptor didn't work from within constructor");
      }
      CallerInterceptor.called = false;
      pojo.someMethod();
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("caller interceptor didn't work");
      }
      CallerInterceptor.called = false;
      nonpojo = new NonadvisedPOJO("helloworld");
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("constructor caller interceptor didn't work");
      }
      CallerInterceptor.called = false;
      nonpojo.remoteTest();
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("caller interceptor didn't work");
      }
      if (nonpojo instanceof Advised)
      {
         throw new RuntimeException("nonpojo is Advised when it shouldn't be");
      }
   }

  /**
   * This method should be a caller pointcut
   */
   public void callSomeMethod()
   {
      CallerInterceptor.called = false;
      pojo = new POJO();
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("constructor caller interceptor didn't work within method");
      }
      CallerInterceptor.called = false;
      pojo.someMethod();
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("caller interceptor didn't work");
      }
   }

   /**
    * This method should not be a caller pointcut
    */
   public void nocallSomeMethod()
   {
      CallerInterceptor.called = false;
      pojo = new POJO();
      if (CallerInterceptor.called)
      {
         throw new RuntimeException("constructor caller interceptor didn't work, interceptor was invoked when it shouldn't have been");
      }
      pojo.someMethod();
      if (CallerInterceptor.called)
      {
         throw new RuntimeException("caller interceptor didn't work, caller interceptor was invoked when it shouldn't have been");
      }
   }

   public void callUnadvised()
   {
      CallerInterceptor.called = false;
      nonpojo = new NonadvisedPOJO("helloworld");
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("consturctor caller interceptor didn't work");
      }
      CallerInterceptor.called = false;
      nonpojo.remoteTest();
      if (!CallerInterceptor.called)
      {
         throw new RuntimeException("caller interceptor didn't work");
      }
      if (nonpojo instanceof Advised)
      {
         throw new RuntimeException("nonpojo is Advised when it shouldn't be");
      }
   }

}

