/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 *
 **/
public class Aspect
{
   public Object interceptConstructor(ConstructorInvocation invocation) throws Throwable
   {
      Object rtn = invocation.invokeNext();
      POJOAspectTester pojo = (POJOAspectTester)rtn;
      pojo.marker = "interceptConstructor";
      return rtn;
   }

   public Object interceptField(FieldInvocation invocation) throws Throwable
   {
      Object rtn = invocation.invokeNext();
      POJOAspectTester pojo = (POJOAspectTester)invocation.getTargetObject();
      pojo.marker = "interceptField";
      return rtn;
   }

   public Object interceptMethod(MethodInvocation invocation) throws Throwable
   {
      Object rtn = invocation.invokeNext();
      POJOAspectTester pojo = (POJOAspectTester)invocation.getTargetObject();
      pojo.marker = "interceptMethod";
      return rtn;
   }
}
