/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.jms.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.jboss.logging.Logger;

/**
 * A provider adapter that uses properties.
 *
 * @version <pre>$Revision:1$</pre>
 * @author <a href="mailto:peter.antman@tim.se">Peter Antman</a>.
 * @author  <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 */
public class JNDIProviderAdapter
   extends AbstractJMSProviderAdapter
{
   public Context getInitialContext() throws NamingException
   {
      if (properties == null)
         return new InitialContext();
      else
         return new InitialContext(properties);
   }
}
