/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security.plugins;

import java.io.IOException;
import java.io.CharArrayWriter;

/** Read a password from the System.in stream. This may be used as a
 password accessor in conjunction with the JaasSecurityDomain
 {CLASS}org.jboss.security.plugins.ConsolePassword
 format of the KeyStorePass attribute.

 @author Scott.Stark@jboss.org
 @version $Revison:$
 */
public class ConsolePassword
{
   public ConsolePassword()
   {
   }

   public char[] toCharArray()
      throws IOException
   {
      System.err.print("Enter password: ");
      CharArrayWriter writer = new CharArrayWriter();
      int b;
      while( (b = System.in.read()) >= 0 )
      {
         if( b == '\r' || b == '\n' )
            break;
         writer.write(b);
      }
      char[] password = writer.toCharArray();
      writer.reset();
      for(int n = 0; n < password.length; n ++)
         writer.write('\0');
      return password;
   }

   public static void main(String[] args) throws IOException
   {
      ConsolePassword cp = new ConsolePassword();
      System.out.println(new String(cp.toCharArray()));
   }
}
