/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 * 
 */
package org.jboss.security.jacc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

/** A PolicyContextHandler for the current authenticated Subject.
 * @author Scott.Stark@jboss.org
 * @version $Revison:$
 */
public class SubjectPolicyContextHandler implements PolicyContextHandler
{
   public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
   public static final HashSet EMPTY_SET = new HashSet();

   private static class GetSubjectAction implements PrivilegedAction
   {
      static PrivilegedAction ACTION = new GetSubjectAction();
      public Object run()
      {
         Subject theSubject = null;
         Subject activeSubject = SecurityAssociation.getSubject();
         if( activeSubject != null )
         {
            Set principalsSet = null;
            RunAsIdentity callerRunAsIdentity = (RunAsIdentity)
               SecurityAssociation.peekRunAsIdentity(1);
            if( callerRunAsIdentity == null )
            {
               principalsSet = activeSubject.getPrincipals();
            }
            else
            {
               principalsSet = callerRunAsIdentity.getRunAsRoles();
            }

            theSubject = new Subject(true, principalsSet,
               activeSubject.getPublicCredentials(),
               activeSubject.getPrivateCredentials());
         }
         else
         {
            RunAsIdentity callerRunAsIdentity = (RunAsIdentity)
               SecurityAssociation.peekRunAsIdentity(1);
            if( callerRunAsIdentity != null )
            {
               Set principalsSet = callerRunAsIdentity.getRunAsRoles();
               theSubject = new Subject(true, principalsSet, EMPTY_SET, EMPTY_SET);
            }
         }
         return theSubject;
      }
   }

   public Object getContext(String key, Object data)
      throws PolicyContextException
   {
      if( key.equalsIgnoreCase(SUBJECT_CONTEXT_KEY) == false )
         return null;

      Subject subject = (Subject) AccessController.doPrivileged(GetSubjectAction.ACTION);
      return subject;
   }

   public String[] getKeys()
      throws PolicyContextException
   {
      String[] keys = {SUBJECT_CONTEXT_KEY};
      return keys;
   }

   public boolean supports(String key)
      throws PolicyContextException
   {
      return key.equalsIgnoreCase(SUBJECT_CONTEXT_KEY);
   }
}
