/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.security.auth.certs;

import java.security.cert.X509Certificate;
import java.security.KeyStore;

/**
 * A verifier for X509Certificate used by authentication layers.
 * 
 * @see org.jboss.security.auth.spi.BaseCertLoginModule
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface X509CertificateVerifier
{
   /**
    * Validate a cert.
    * 
    * @param cert - the X509Certificate to verifier
    * @param alias - the expected keystore alias
    * @param keyStore - the keystore for the cert
    * @param trustStore - the truststore for the cert signer
    * @return true if the cert is valid, false otherwise
    */ 
   public boolean verify(X509Certificate cert, String alias,
      KeyStore keyStore, KeyStore trustStore);
}
