/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security.auth.certs;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.math.BigInteger;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.SimplePrincipal;

/** A CertificatePrincipal implementation that builds the principal name
 * based on the cert serialNumber and issuerDN
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SerialNumberIssuerDNMapping
   implements CertificatePrincipal
{
   /** Create a SimplePrincipal with the name composed from
    * certs[0].getSerialNumber() + " " + certs[0].getIssuerDN()
    *
    * @param certs Array of client certificates, with the first one in
    * the array being the certificate of the client itself.
    */
   public Principal toPrinicipal(X509Certificate[] certs)
   {
      BigInteger serialNumber = certs[0].getSerialNumber();
      Principal issuer = certs[0].getIssuerDN();
      SimplePrincipal principal = new SimplePrincipal(serialNumber+" "+issuer);
      return principal;
   }
}
