/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.transport.socket;

import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.mock.MockServerInvocationHandler;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/**
 * This is the concrete test for invoker server.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class InvokerServerTest extends AbstractInvokerTest
{
   private static final Logger log = Logger.getLogger(InvokerServerTest.class);

   public InvokerServerTest(String name)
   {
      super(name);
   }

   public InvokerServerTest(int instances)
   {
      super(InvokerServerTest.class.getName(), instances);
   }

   public InvokerServerTest(String transport, int port)
   {
      super(InvokerServerTest.class.getName(), transport, port);
   }

   public InvokerServerTest(String transport, int port, int instances)
   {
      super(InvokerServerTest.class.getName(), transport, port, instances);
   }

   public void init(Map metatdata) throws Exception
   {
      if(port < 0)
      {
         port = Math.abs(new Random().nextInt(2000) + 2000);
      }
      log.debug("port = " + port);

//        InvokerRegistry.registerInvoker(getTransport(), SocketClientInvoker.class, SocketServerInvoker.class);
//        InvokerRegistry.registerInvoker("mock", MockClientInvoker.class, MockServerInvoker.class);
      Connector connector = new Connector();
      InvokerLocator locator = new InvokerLocator(buildLocatorURI(metatdata));
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.start();
      connector.addInvocationHandler(getSubsystem(), getServerInvocationHandler());
   }

   private String buildLocatorURI(Map metadata)
   {
      if(metadata == null || metadata.size() == 0)
      {
         return getTransport() + "://localhost:" + port;
      }
      else
      {
         StringBuffer uriBuffer = new StringBuffer(getTransport() + "://localhost:" + port);

         Set keys = metadata.keySet();
         Iterator itr = keys.iterator();
         while(itr.hasNext())
         {
            String key = (String) itr.next();
            String value = (String) metadata.get(key);
            uriBuffer.append(key + "=" + value + ",");
         }
         return uriBuffer.substring(0, uriBuffer.length() - 1);
      }
   }

   protected String getSubsystem()
   {
      return "mock";
   }

   protected ServerInvocationHandler getServerInvocationHandler()
   {
      return new MockServerInvocationHandler();
   }

   public void serverTest() throws Exception
   {
      try
      {
         init(null);
         startup(getNumberOfInstances());
         shutdown();
      }
      catch(Exception e)
      {
         log.error("Error in serverTest() of " + this.getClass().getName(), e);
         throw e;
      }
   }

   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jgroups").setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("test").setLevel(Level.DEBUG);

      InvokerServerTest server = null;
      if(args.length == 1)
      {
         int instances = Integer.parseInt(args[0]);
         server = new InvokerServerTest(instances);
      }
      else if(args.length == 2)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         server = new InvokerServerTest(transport, port);
      }
      else if(args.length == 3)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         int instances = Integer.parseInt(args[2]);
         server = new InvokerServerTest(transport, port, instances);
      }
      else
      {
         server = new InvokerServerTest(InvokerServerTest.class.getName());
         System.out.println("Using default transport (" + server.getTransport() +
                            ") and default port (" + server.getPort() + ") and " +
                            "default number of instances (" + server.getNumberOfInstances() + ")" +
                            "\nCan enter transport, port, and instances via command line.");
      }

      try
      {
         server.serverTest();
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

}
