/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.transport.http;

import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.Connector;

import javax.management.MBeanServer;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class HTTPInvokerTestServer extends AbstractInvokerTest
{
   // Default locator values
   private static String transport = "http";
   private static String host = "localhost";
   private static int port = 8888;

   // String to be returned from invocation handler upon client invocation calls.
   public static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";
   public static final ComplexObject OBJECT_RESPONSE_VALUE = new ComplexObject(5, "dub", false);

   public static final String NULL_RETURN_PARAM = "return_null";
   public static final String OBJECT_RETURN_PARAM = "return_object";

   public HTTPInvokerTestServer(String name)
   {
      super(name);
   }

   public HTTPInvokerTestServer(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public HTTPInvokerTestServer(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public HTTPInvokerTestServer(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }


   public void setupServer() throws Exception
   {
      String locatorURI = transport + "://" + host + ":" + port;
      InvokerLocator locator = new InvokerLocator(locatorURI);
      System.out.println("Starting remoting server with locator uri of: " + locatorURI);
      Connector connector = new Connector();
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.start();

      HTTPInvokerTestServer.SampleInvocationHandler invocationHandler = new HTTPInvokerTestServer.SampleInvocationHandler();
      // first parameter is sub-system name.  can be any String value.
      connector.addInvocationHandler("sample", invocationHandler);
   }

   public void serverTest() throws Exception
   {
      try
      {
         setupServer();
         startup(getNumberOfInstances());
         shutdown();
      }
      catch(Exception e)
      {
         throw e;
      }
   }


   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      int numOfInstance = 2;

      if(args != null && args.length == 1)
      {
         numOfInstance = Integer.parseInt(args[0]);
      }
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }
      String locatorURI = transport + "://" + host + ":" + port;
      HTTPInvokerTestServer server = new HTTPInvokerTestServer(HTTPInvokerTestServer.class.getName(), numOfInstance);
      try
      {
         server.serverTest();

         // sleep the thread for 10 seconds while waiting for client to call
         //Thread.sleep(60000);
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

   /**
    * Simple invocation handler implementation.
    */
   public static class SampleInvocationHandler implements ServerInvocationHandler
   {


      /**
       * called to handle a specific invocation
       *
       * @param invocation
       * @return
       * @throws Throwable
       */
      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         // Print out the invocation request
         System.out.println("Invocation request is: " + invocation.getParameter());
         if(NULL_RETURN_PARAM.equals(invocation.getParameter()))
         {
            return null;
         }
         else if(invocation.getParameter() instanceof ComplexObject)
         {
            return OBJECT_RESPONSE_VALUE;
         }
         else
         {
            // Just going to return static string as this is just simple example code.
            return RESPONSE_VALUE;
         }
      }

      /**
       * Adds a callback handler that will listen for callbacks from
       * the server invoker handler.
       *
       * @param callbackHandler
       */
      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * Removes the callback handler that was listening for callbacks
       * from the server invoker handler.
       *
       * @param callbackHandler
       */
      public void removeListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * set the mbean server that the handler can reference
       *
       * @param server
       */
      public void setMBeanServer(MBeanServer server)
      {
         // NO OP as do not need reference to MBeanServer for this handler
      }

      /**
       * set the invoker that owns this handler
       *
       * @param invoker
       */
      public void setInvoker(ServerInvoker invoker)
      {
         // NO OP as do not need reference back to the server invoker
      }

   }

}