/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.transport.http;

import org.jboss.dtf.MultipleTestRunner;
import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class HTTPInvokerTestClient extends AbstractInvokerTest
{
   // Default locator values
   private static String transport = "http";
   private static String host = "localhost";
   private static int port = 8888;

   public HTTPInvokerTestClient(String name)
   {
      super(name);
   }

   public HTTPInvokerTestClient(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public HTTPInvokerTestClient(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public HTTPInvokerTestClient(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }

   public void testInvocation() throws Exception
   {
      String locatorURI = transport + "://" + host + ":" + port;
      InvokerLocator locator = new InvokerLocator(locatorURI);
      System.out.println("Calling remoting server with locator uri of: " + locatorURI);

      // This could have been new Client(locator), but want to show that subsystem param is null
      // Could have also been new Client(locator, "sample");
      Client remotingClient = new Client(locator, null);

      Map metadata = new HashMap();
      metadata.put(Client.RAW, Boolean.TRUE);
      metadata.put("TYPE", "POST");

      Properties headerProps = new Properties();
      headerProps.put("SOAPAction", "http://www.example.com/fibonacci");
      headerProps.put("Content-type", "application/soap+xml");

      metadata.put("HEADER", headerProps);

      Object response = null;

      // test with null return expected
      try
      {
         response = remotingClient.invoke(HTTPInvokerTestServer.NULL_RETURN_PARAM, metadata);
      }
      catch(Throwable throwable)
      {
         throw new Exception(throwable);
      }

      assertNull(response);

      try
      {
         response = remotingClient.invoke("Do something", metadata);
      }
      catch(Throwable throwable)
      {
         throw new Exception(throwable);
      }

      assertEquals(HTTPInvokerTestServer.RESPONSE_VALUE, response);

      headerProps.put("Content-type", HTTPServerInvoker.BINARY);
      try
      {
         response = remotingClient.invoke(new ComplexObject(2, "foo", true), metadata);
      }
      catch(Throwable throwable)
      {
         throw new Exception(throwable);
      }

      assertEquals(HTTPInvokerTestServer.OBJECT_RESPONSE_VALUE, response);

   }

   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      int numberOfInstances = 2;

      if(args != null && args.length == 1)
      {
         numberOfInstances = Integer.parseInt(args[0]);
      }
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }

      HTTPInvokerTestClient client = new HTTPInvokerTestClient(HTTPInvokerTestClient.class.getName(), numberOfInstances);
      try
      {
         //regular class run
         MultipleTestRunner runner = new MultipleTestRunner();
         runner.doRun(client, true);
      }
      catch(Throwable e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);

   }

}