/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.performance.oneway;

import org.apache.log4j.Level;
import org.jboss.dtf.MultipleTestRunner;
import org.jboss.remoting.oneway.OnewayInvokerClientTest;
import org.jboss.remoting.performance.PerformanceTest;

/**
 * Makes oneway (client side thread pooling) call a number of times using multiple threads
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class ServerOnewayInvocationTest extends OnewayTest
{
   public ServerOnewayInvocationTest(String name)
   {
      super(name);
   }

   public ServerOnewayInvocationTest(int numberOfInstances)
   {
      super(numberOfInstances);
   }

   public ServerOnewayInvocationTest(String transport, int port)
   {
      super(transport, port);
   }

   public ServerOnewayInvocationTest(String transport, int port, int numberOfInstances)
   {
      super(transport, port, numberOfInstances);
   }

   protected void printStartMessage()
   {
      System.out.println("\n*****************************************************\n" +
                         "Starting oneway preformance test with server oneway.\n" +
                         "*****************************************************\n");
   }

   protected Runnable getRunner(String method)
   {
      return new ServerRunner(method);
   }

   public void testOnewayClientInvocation() throws Throwable
   {
      //NO OP since don't want to run this one in this case
   }

   public void testInvocation() throws Throwable
   {
      //NO OP since don't want to run this one in this case
   }


   public class ServerRunner implements Runnable
   {
      private String method;

      public ServerRunner(String method)
      {
         this.method = method;
      }

      public void run()
      {
         for(int i = 0; i < PerformanceTest.NUM_OF_CALLS; i++)
         {
            try
            {
               superMakeServerOnewayInvocation(this.method,
                                               String.valueOf(incrementCallCount()));
            }
            catch(Throwable throwable)
            {
               throwable.printStackTrace();
            }
         }
      }
   }


   public static void main(String[] args)
   {

      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jgroups").setLevel(Level.INFO);
      //org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.DEBUG);
      //org.apache.log4j.Category.getInstance("test").setLevel(Level.DEBUG);

      ServerOnewayInvocationTest client = null;
      if(args.length == 1)
      {
         int instances = Integer.parseInt(args[0]);
         client = new ServerOnewayInvocationTest(instances);
      }
      else if(args.length == 2)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         client = new ServerOnewayInvocationTest(transport, port);
      }
      else if(args.length == 3)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         int instances = Integer.parseInt(args[2]);
         client = new ServerOnewayInvocationTest(transport, port, instances);
      }
      else
      {
         client = new ServerOnewayInvocationTest(OnewayInvokerClientTest.class.getName());
         System.out.println("Using default transport (" + client.getTransport() +
                            ") and default port (" + client.getPort() + ") and " +
                            "default number of instances (" + client.getNumberOfInstances() + ")" +
                            "\nCan enter transport, port, and instances via command line.");
      }

      try
      {
         //regular class run
         //client.runInvokers();
         MultipleTestRunner runner = new MultipleTestRunner();
         runner.doRun(client, true);
      }
      catch(Throwable e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

}