/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.remoting.performance;

import org.jboss.dtf.DistributedTestCase;
import org.jgroups.Address;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public abstract class PerformanceTest extends DistributedTestCase
{
   public static final int NUM_OF_THREADS = 10;
   public static final int NUM_OF_CALLS = 500;

   private List results = new ArrayList();
   protected String transport = "socket";
   protected int port = 4555;

   public PerformanceTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      transport = System.getProperty("remoting.transport", transport);
      port = Integer.valueOf(System.getProperty("remoting.port", String.valueOf(port))).intValue();

      String clientFQN = getClientFQN();
      String serverFQN = getServerFQN();

      String clientcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.local.dir") +
                         " " + clientFQN + " " + transport + " " + port + " 3";
      System.out.println("clientcmd: " + clientcmd);
      String svrcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.remote.dir") +
                      " " + serverFQN + " " + transport + " " + port + " 3";
      System.out.println("svrcmd: " + svrcmd);

      final Process local = Runtime.getRuntime().exec(clientcmd);
      final Process remote = Runtime.getRuntime().exec(svrcmd);
   }

   public abstract String getClientFQN();

   public abstract String getServerFQN();

   protected void tearDown() throws Exception
   {
      //NO OP since manually controlling shutdown
   }

   public void testInvokers()
   {
      try
      {
         startup(3);
         System.out.println("startup() called");
         shutdown();
         System.out.println("shutdown() called");
      }
      catch(Exception e)
      {
         e.printStackTrace();
         try
         {
            PerformanceReporter.writeReport("Error in test.  Instances either failed to start or stop.", 0, 0, null);
         }
         catch(IOException e1)
         {
            e1.printStackTrace();
         }
         assertTrue("Problem starting or stopping client/server processes.", false);
      }
      finally
      {
         // assert results
         try
         {
            Thread.currentThread().sleep(10000);
         }
         catch(InterruptedException e)
         {
            e.printStackTrace();
         }
         System.out.println("results.size() = " + results.size());
         if(results.size() > 0)
         {
            Iterator itr = results.iterator();
            while(itr.hasNext())
            {
               String message = (String) itr.next();
               assertTrue(message, false);
            }
         }
         else
         {
            assertTrue("No test failures or errors.", true);
         }

      }
   }

   /**
    * **********************************
    * Driver callback for JUnit asserts *
    * ***********************************
    */
   public void receiveAssert(Address source, String message)
   {
      super.receiveAssert(source, message);
      results.add("Assert source: " + source + "\tmessage: " + message);
   }

}
