/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.remoting.marshall.serializable;

import junit.framework.TestCase;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class SerializableMarshallingTestCase extends TestCase
{
   private Marshaller marshaller;
   private UnMarshaller unmarshaller;

   protected void setUp() throws Exception
   {
      super.setUp();
      marshaller = MarshalFactory.getMarshaller(SerializableMarshaller.DATATYPE);
      unmarshaller = MarshalFactory.getUnMarshaller(SerializableUnMarshaller.DATATYPE);
   }

   public void testMarshalling() throws IOException, ClassNotFoundException
   {
      String testData = "This is some test data";
      Object param = new String(testData);

      ByteArrayOutputStream output = new ByteArrayOutputStream();
      marshaller.write(param, output);
      byte[] byteArray = new byte[output.size()];
      byteArray = output.toByteArray();
      ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
      Object result = unmarshaller.read(input, null);

      System.out.println("Result: " + result);
      assertEquals(testData, result);
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      marshaller = null;
      unmarshaller = null;
   }

}
