/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshall.dynamic.remote.http;

import org.apache.log4j.Level;
import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshall.dynamic.remote.socket.MarshallerLoadingConstants;
import org.jboss.remoting.marshall.dynamic.remote.socket.TestMarshaller;
import org.jboss.remoting.marshall.dynamic.remote.socket.TestUnMarshaller;
import org.jboss.remoting.transport.Connector;

import javax.management.MBeanServer;

/**
 * Simple remoting server.  Uses inner class SampleInvocationHandler
 * as the invocation target handler class.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class MarshallerLoadingServer extends AbstractInvokerTest  implements org.jboss.remoting.marshall.dynamic.remote.socket.MarshallerLoadingConstants
{

   // String to be returned from invocation handler upon client invocation calls.
   private static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";

   public MarshallerLoadingServer(String name)
   {
      super(name);
   }

   public MarshallerLoadingServer(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public MarshallerLoadingServer(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public MarshallerLoadingServer(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }


   public void setupServer() throws Exception
   {
      String mylocatorURI = MarshallerLoadingConstants.transport + "://" + host + ":" + org.jboss.remoting.marshall.dynamic.remote.socket.MarshallerLoadingConstants.port + "/?" +
                              InvokerLocator.DATATYPE + "=" + dataType + "&" +
                              InvokerLocator.LOADER_PORT + "=" + 5401 + "&" +
                              InvokerLocator.MARSHALLER + "=" + TestMarshaller.class.getName() + "&" +
                              InvokerLocator.UNMARSHALLER + "=" + TestUnMarshaller.class.getName();

      System.out.println("mylocatorURI: " + mylocatorURI);
      System.out.println("locatorURI: " + locatorURI);
      //InvokerLocator locator = new InvokerLocator(locatorURI);
      InvokerLocator locator = new InvokerLocator(mylocatorURI);
      System.out.println("Starting remoting server with locator uri of: " + locatorURI);
      Connector connector = new Connector();
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.start();

      SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
      // first parameter is sub-system name.  can be any String value.
      connector.addInvocationHandler("sample", invocationHandler);
   }

   public void serverTest() throws Exception
   {
         setupServer();
         startup(getNumberOfInstances());
         shutdown();
   }

   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.DEBUG);
      //org.apache.log4j.Category.getInstance(DistributedTestCase.class).setLevel(Level.DEBUG);

      /*
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }
      */
      MarshallerLoadingServer server = new MarshallerLoadingServer(MarshallerLoadingServer.class.getName());
      try
      {
         server.serverTest();

         // sleep the thread for 10 seconds while waiting for client to call
         Thread.sleep(10000);
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

   /**
    * Simple invocation handler implementation.
    */
   public static class SampleInvocationHandler implements ServerInvocationHandler
   {
      /**
       * called to handle a specific invocation
       *
       * @param invocation
       * @return
       * @throws Throwable
       */
      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         // Print out the invocation request
         System.out.println("Invocation request is: " + invocation.getParameter());

         // Just going to return static string as this is just simple example code.
         return RESPONSE_VALUE;
      }

      /**
       * Adds a callback handler that will listen for callbacks from
       * the server invoker handler.
       *
       * @param callbackHandler
       */
      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * Removes the callback handler that was listening for callbacks
       * from the server invoker handler.
       *
       * @param callbackHandler
       */
      public void removeListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * set the mbean server that the handler can reference
       *
       * @param server
       */
      public void setMBeanServer(MBeanServer server)
      {
         // NO OP as do not need reference to MBeanServer for this handler
      }

      /**
       * set the invoker that owns this handler
       *
       * @param invoker
       */
      public void setInvoker(ServerInvoker invoker)
      {
         // NO OP as do not need reference back to the server invoker
      }

   }
}