/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshall.dynamic.remote.http;

import org.jboss.remoting.InvokerLocator;

/**
 * @author <a href="mailto:telrod@jboss.com">Tom Elrod</a>
 */
public interface MarshallerLoadingConstants
{
   // Default locator values
   static String transport = "http";
//   static String transport = "socket";
   static String host = "localhost";
   static int port = 5402;
   static int loaderPort = 5403;

   static String dataType = "test";
   static String locatorURI = transport + "://" + host + ":" + port + "/?" +
                              InvokerLocator.DATATYPE + "=" + dataType + "&" +
                              InvokerLocator.LOADER_PORT + "=" + loaderPort + "&" +
                              InvokerLocator.MARSHALLER + "=" + "org.jboss.remoting.marshall.dynamic.TestMarshaller" + "&" +
                              InvokerLocator.UNMARSHALLER + "=" + "org.jboss.remoting.marshall.dynamic.TestUnMarshaller";
   ;
}
