/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.interceptor;

import junit.framework.TestCase;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.interceptors.invoker.InvokerInterceptor;
import org.jboss.aspects.remoting.interceptors.invoker.RemotingInterceptorFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;

import java.net.MalformedURLException;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class ClientInterceptorTest extends TestCase
{
   private boolean passed = false;

   public void runTest() throws MalformedURLException
   {
      // Create interceptor stack
      Interceptor[] interceptorStack = new Interceptor[]{new InvokerInterceptor()};

      TestInvocation invocation = new TestInvocation(interceptorStack);
      invocation.setArgument(new TestTarget());

      int port = 8081;
      String transport = "socket";

      InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port + "/?" +
                                                  InvokerLocator.DATATYPE + "=" + SerializableMarshaller.DATATYPE);
      invocation.getMetaData().addMetaData(RemotingInterceptorFactory.REMOTING,
                                           RemotingInterceptorFactory.INVOKER_LOCATOR, locator, PayloadKey.TRANSIENT);

      try
      {
         Object ret = invocation.invokeNext();
         if(ret instanceof Boolean && ((Boolean) ret).booleanValue())
         {
            assertTrue("Simple interceptor test passed.  Value returned was not true.", true);
            System.out.println("Test PASSED.");
            passed = true;
         }
         else
         {
            assertTrue("Simple interceptor test passed.  Value returned was not true.", false);
            System.out.println("Test FAILED!!!");
            passed = false;
         }
      }
      catch(Throwable throwable)
      {
         throwable.printStackTrace();
      }
   }

   public boolean isTestPassing()
   {
      return passed;
   }

   public static void main(String[] args)
   {
      try
      {
         new ClientInterceptorTest().runTest();
      }
      catch(MalformedURLException e)
      {
         e.printStackTrace();
      }
   }

}