/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.exception.cannotconnect.rmi;

import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.invocation.NameBasedInvocation;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class CannotConnectTestCase extends TestCase
{
   private static final Logger log = Logger.getLogger(CannotConnectTestCase.class);

   public void testCannotConnect()
   {

      try
      {
         log.debug("running testCannotConnect()");

         InvokerLocator locator = new InvokerLocator("rmi://localhost:8823");
         Client client = new Client(locator, "mock");
         client.connect();

         log.debug("client.getInvoker().getLocator()" + client.getInvoker().getLocator());

         Object ret = client.invoke(new NameBasedInvocation("foo",
               new Object[]{"bar"},
               new String[]{String.class.getName()}),
               null);
      }
      catch (CannotConnectException cce)
      {
         log.debug("Got CannotConnectException as expected.");
         assertTrue(true);
      }
      catch (Throwable tr)
      {
         tr.printStackTrace();
         assertTrue("Did not catch CannotConnectException as expected.", false);
      }
   }
}