/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.callback.pull.memory.nullstore;

import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.pull.memory.CallbackInvocationHandler;
import org.jboss.remoting.transport.Connector;

/**
 * Simple remoting server.  Uses inner class SampleInvocationHandler
 * as the invocation target handler class.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class CallbackTestServer extends AbstractInvokerTest
{
   // Default locator values
   private static String transport = "socket";
   private static String host = "localhost";
   private static int port = 5411;

   private String locatorURI = null;

   // String to be returned from invocation handler upon client invocation calls.
   private static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";

   public CallbackTestServer(String name)
   {
      super(name);
   }

   public CallbackTestServer(String name, String locatorURI)
   {
      super(name);
      this.locatorURI = locatorURI;
   }

   public CallbackTestServer(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public CallbackTestServer(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public CallbackTestServer(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }


   public void setupServer() throws Exception
   {
      InvokerLocator locator = new InvokerLocator(locatorURI);
      System.out.println("Starting remoting server with locator uri of: " + locatorURI);
      Connector connector = new Connector();
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.start();

      CallbackInvocationHandler invocationHandler = new CallbackInvocationHandler();
      // first parameter is sub-system name.  can be any String value.
      connector.addInvocationHandler("sample", invocationHandler);
   }

   public void serverTest() throws Exception
   {
      try
      {
         setupServer();
         startup(getNumberOfInstances());
         // sleep the thread for 15 seconds while waiting for client to call
         Thread.sleep(15000);
         shutdown();
      }
      catch(Exception e)
      {
         throw e;
      }
   }

   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }
      String locatorURI = transport + "://" + host + ":" + port;
      CallbackTestServer server = new CallbackTestServer(CallbackTestServer.class.getName(), locatorURI);
      try
      {
         server.serverTest();
         // sleep the thread for 15 seconds while waiting for client to call
         Thread.sleep(15000);
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

}