/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.byvalue;

import junit.framework.TestCase;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.mock.MockServerInvocationHandler;

/**
 * Just a simple example of how to setup remoting to make an invocation to local target,
 * so are not actually going out of process, thus not really using any transport protocol.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class ByValueInvocationTestCase extends TestCase
{
   public ByValueInvocationTestCase(String name)
   {
      super(name);
   }

   public static void setupConfiguration(InvokerLocator locator, ServerInvocationHandler invocationHandler) throws Exception
   {
      Connector connector = new Connector();
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.start();
      connector.addInvocationHandler("mock", invocationHandler);
   }

   public void testInvocation() throws Throwable
   {
      InvokerLocator locator = new InvokerLocator("rmi://localhost:5400/?" +
                                                  InvokerLocator.BYVALUE + "=" + Boolean.TRUE.toString());
      ServerInvocationHandler invocationHandler = new MockServerInvocationHandler();

      // set up
      ByValueInvocationTestCase.setupConfiguration(locator, invocationHandler);

      Thread.sleep(3000);

      // This could have been new Client(locator), but want to show that subsystem param is null
      Client remotingClient = new Client(locator, null);
      ByValuePayload byValuePayload = new ByValuePayload();
      Object response = remotingClient.invoke(new NameBasedInvocation("testByValue",
                                                                      new Object[]{byValuePayload},
                                                                      new String[]{byValuePayload.getClass().getName()}),
                                              null);

      System.out.println("Invocation response: " + response);
      if(response instanceof Boolean)
      {
         assertTrue("Result of testByValue is false.", ((Boolean) response).booleanValue());
      }
      else
      {
         assertTrue("Result of testByValue was not even of type Boolean.", false);
      }

   }

}