/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.transport;

/**
 * MBean interface.
 */
public interface ConnectorMBean {

   /**
    * Starts the connector.
    */
  void start() throws java.lang.Exception;

   /**
    * Stops the connector.
    */
  void stop() ;

   /**
    * Creates the connector.
    */
  void create() throws java.lang.Exception;

   /**
    * Destroys the connector.
    */
  void destroy() ;

   /**
    * Returns the locator to the connector. Locator is the actual InvokerLocator object used to identify and get the ServerInvoker we are wrapping.
    */
  org.jboss.remoting.InvokerLocator getLocator() ;

   /**
    * Sets the invoker locator. InvokerLocator is the string URI representation of the InvokerLocator used to get and identify the ServerInvoker we are wrapping.
    */
  void setInvokerLocator(java.lang.String locator) throws java.lang.Exception;

   /**
    * Returns the invoker locator. InvokerLocator is the string URI representation of the InvokerLocator used to get and identify the ServerInvoker we are wrapping.
    */
  java.lang.String getInvokerLocator() throws java.lang.Exception;

   /**
    * Configuration is an xml element indicating subsystems to be registered with the ServerInvoker we wrap. Using mbean subsystems that call registerSubsystem is more flexible.
    */
  void setConfiguration(org.w3c.dom.Element xml) throws java.lang.Exception;

   /**
    * Configuration is an xml element indicating subsystems to be registered with the ServerInvoker we wrap. Using mbean subsystems that call registerSubsystem is more flexible.
    */
  org.w3c.dom.Element getConfiguration() ;

   /**
    * Adds a handler to the connector via OjbectName. This will create a mbean proxy of type of ServerInvocationHandler for the MBean specified by object name passed (so has to implement ServerInvocationHandler interface).
    * @param subsystem
    * @param handlerObjectName
    * @throws Exception
    */
  void addInvocationHandler(java.lang.String subsystem,javax.management.ObjectName handlerObjectName) throws java.lang.Exception;

   /**
    * Adds an invocation handler for the named subsystem to the invoker we manage, and sets the mbean server on the invocation handler.
    */
  void addInvocationHandler(java.lang.String subsystem,org.jboss.remoting.ServerInvocationHandler handler) throws java.lang.Exception;

   /**
    * Removes an invocation handler for the supplied subsystem from the invoker we manage, and unsets the MBeanServer on the handler.
    */
  void removeInvocationHandler(java.lang.String subsystem) throws java.lang.Exception;

}
