/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network.filter;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkFilter;

/**
 * InvokerProtocolFilter will examine the protocol of the InvokerLocators on the
 * server and return true for the filter if the protocol matches our spec.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class InvokerProtocolFilter implements NetworkFilter
{
    private final String protocol;

    public InvokerProtocolFilter (String protocol)
    {
        this.protocol = protocol;
    }

    /**
     * called to apply a filter when selecting <tt>0..*</tt> servers on the network
     *
     * @param identity
     * @param locators
     * @return
     */
    public boolean filter (Identity identity, InvokerLocator locators[])
    {
        if (locators!=null)
        {
           for (int c=0;c<locators.length;c++)
           {
               // we found a transport that matches
               if (locators[c].getProtocol().equalsIgnoreCase(protocol))
               {
                   return true;
               }
           }
        }
        return false;
    }
}
