/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;

import javax.management.Notification;
import javax.management.ObjectName;

/**
 * NetworkNotification is a JMX Notification that is sent when changes occur to the network layout as
 * tracked by a NetworkRegistryMBean.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class NetworkNotification extends Notification
{
    public static final String SERVER_ADDED =   "jboss.network.server.added";
    public static final String SERVER_UPDATED = "jboss.network.server.updated";
    public static final String SERVER_REMOVED = "jboss.network.server.removed";
    public static final String DOMAIN_CHANGED = "jboss.network.domain.changed";

    private final Identity identity;
    private final InvokerLocator invokers[];

    public NetworkNotification (ObjectName source, String type, Identity identity, InvokerLocator invokers[])
    {
        super(type,source,System.currentTimeMillis());
        this.identity = identity;
        this.invokers = invokers;
    }
    /**
     * return the identity of the notification
     *
     * @return
     */
    public final Identity getIdentity ()
    {
        return identity;
    }
    /**
     * return the locators affected by the notification
     *
     * @return
     */
    public final InvokerLocator[] getLocator ()
    {
        return invokers;
    }
}
