/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.detection.util;

import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.Detector;
import org.jboss.remoting.detection.jndi.JNDIDetector;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;
import org.w3c.dom.Document;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;


/**
 * @author <a href="mailto:telrod@vocalocity.net">Tom Elrod</a>
 * @version $Revision:1$
 */
public class DetectorUtil
{
   /**
    * multicast *
    */
   public static final String TYPE_MULTICAST = "multicast";
   /**
    * jndi *
    */
   public static final String TYPE_JNDI = "jndi";
   /**
    * 2410 *
    */
   public static final int DEFAULT_PORT = 2410;
   /**
    * localhost *
    */
   public static final String DEFAULT_HOST = "localhost";

   private String contextFactory = "org.jnp.interfaces.NamingContextFactory";
   private String urlPackage = "org.jboss.naming:org.jnp.interfaces";

   private String type = TYPE_MULTICAST;
   private int port = DEFAULT_PORT;
   private String host = DEFAULT_HOST;

   public DetectorUtil()
   {
   }

   public DetectorUtil(String type)
   {
      this(type, DEFAULT_PORT, DEFAULT_HOST);
   }

   public DetectorUtil(String type, int port)
   {
      this(type, port, DEFAULT_HOST);
   }

   public DetectorUtil(String type, int port, String host)
   {
      this.type = type;
      this.port = port;
      this.host = host;
   }

   public void start()
   {
      try
      {

         org.apache.log4j.BasicConfigurator.configure();
         org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);
         Logger log = Logger.getLogger(getClass());

         System.setProperty("jboss.identity", String.valueOf(System.currentTimeMillis()));

         MBeanServer server = MBeanServerFactory.createMBeanServer();

         NetworkRegistry registry = NetworkRegistry.getInstance();
         server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));

         InvokerLocator locator = new InvokerLocator("socket://localhost");
         //ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
         //SocketServerInvoker invokerSvr = new SocketServerInvoker(clsLoader, locator);
         //ObjectName objName = new ObjectName("jboss.remoting:type=SocketServerInvoker");
         //server.registerMBean(invokerSvr, objName);
         //invokerSvr.start();

         Connector connector = new Connector();
         StringBuffer buf = new StringBuffer();
         buf.append("<?xml version=\"1.0\"?>\n");
         buf.append("<handlers>\n");
         buf.append("  <handler subsystem=\"mock\">org.jboss.remoting.transport.mock.MockServerInvocationHandler</handler>\n");
         buf.append("</handlers>\n");
         Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
         connector.setInvokerLocator(locator.getLocatorURI());
         connector.setConfiguration(xml.getDocumentElement());
         ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
         server.registerMBean(connector, obj);
         //connector.create();
         connector.start();

         Detector detector = null;
         ObjectName objName = null;

         if (type.equals(TYPE_MULTICAST))
         {
            MulticastDetector mdet = new MulticastDetector();
            mdet.setPort(port);
            detector = mdet;
            objName = new ObjectName("remoting:type=Detector,transport=multicast");
         }
         else if (type.equals(TYPE_JNDI))
         {
            JNDIDetector jdet = new JNDIDetector();
            jdet.setPort(port);
            jdet.setHost(host);
            jdet.setContextFactory(contextFactory);
            jdet.setURLPackage(urlPackage);
            detector = jdet;
            objName = new ObjectName("remoting:type=Detector,transport=jndi");
         }

         server.registerMBean(detector, objName);
         detector.start();
         System.err.println("Starting Detector");

         while (true)
         {
            Thread.currentThread().sleep(3000);
            NetworkInstance[] instances = registry.getServers();
            for (int x = 0; x < instances.length; x++)
            {
               log.debug(instances[x]);
            }
         }


      }
      catch (Exception ex)
      {
         System.err.println("Error creating and starting DetectorUtil.");
         ex.printStackTrace();
      }
   }

   public static void main(String[] args)
   {
      DetectorUtil test = null;

      if (args.length == 1)
      {
         String type = args[0];
         test = new DetectorUtil(type);
      }
      else if (args.length == 2)
      {
         String type = args[0];
         int port = Integer.parseInt(args[1]);
         test = new DetectorUtil(type, port);
      }
      else if (args.length == 3)
      {
         String type = args[0];
         int port = Integer.parseInt(args[1]);
         String host = args[2];
         test = new DetectorUtil(type, port, host);
      }
      else
      {
         test = new DetectorUtil();
         System.out.println("Using default type (" + test.getTransport() +
               ") and default port (" + test.getPort() + ") and " +
               "default host (" + test.getHost() + ")" +
               "\nCan enter type (multicast, jndi), port, and/or host via command line.");
      }

      test.start();


   }

   private String getHost()
   {
      return host;
   }

   private int getPort()
   {
      return port;
   }

   private String getTransport()
   {
      return type;
   }


}
