/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.detection;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;

import java.io.Serializable;

/**
 * Detection is an MBean Notification that is fired by
 * Detectors when remote servers are found or lost on the Network.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class Detection implements Serializable
{
    static final long serialVersionUID = -7560953564286960592L;

    private final InvokerLocator locators[];
    private final Identity identity;
    private final int hashCode;

    public Detection (Identity identity, InvokerLocator locators[])
    {
        this.locators = locators;
        this.identity = identity;
        this.hashCode = identity.hashCode();
    }
    public boolean equals (Object obj)
    {
        if (obj instanceof Detection)
        {
            return hashCode==obj.hashCode();
        }
        return false;
    }
    public int hashCode ()
    {
        return hashCode;
    }

    public String toString ()
    {
        return "Detection [identity:"+identity+",locators:"+(locators==null?0:locators.length)+"]";
    }
    /**
     * return the jboss identity
     *
     * @return
     */
    public final Identity getIdentity ()
    {
        return identity;
    }
    /**
     * return the locators for the server
     *
     * @return
     */
    public final InvokerLocator[] getLocators ()
    {
        return locators;
    }
}
