/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;




/**
 * Should be used a receiver of asynchronous  callbacks for registered listeners.
 * Upon being called with a callback message, will send back to the client.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version $Revision:1$
 */
public interface InvokerCallbackHandler
{
    /**
     * Will take the callback message and send back to client.
     * If client locator is null, will store them till client polls to get them.
     *
     * @param invocation
     * @throws HandleCallbackException
     */
    public void handleCallback(InvocationRequest invocation)
            throws HandleCallbackException;

}
