/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

/**
 * ConnectionFailedException is a RuntimeException that is raised when a remote connection
 * fails.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class ConnectionFailedException extends RuntimeException
{
   /** @since 4.0.1 */
   static final long serialVersionUID = 1353105726630086615L;

   public ConnectionFailedException ()
    {
        super();
    }
    public ConnectionFailedException (String msg)
    {
        super(msg);
    }

   public ConnectionFailedException(String msg, Exception ex)
   {
      super(msg, ex);
   }
}
